/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.client.compat;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class FakeLevel
implements BlockAndTintGetter {
    private final Map<BlockPos, BlockState> blocks;
    public static final Vector3f SCENE_LIGHT_1 = new Vector3f(1.0f, 0.0f, 1.0f);
    public static final Vector3f SCENE_LIGHT_2 = new Vector3f(-1.0f, 1.0f, -1.0f);

    public FakeLevel(Map<BlockPos, BlockState> blocks) {
        this.blocks = blocks;
    }

    public float getShade(Direction direction, boolean shade) {
        return 1.0f;
    }

    public LevelLightEngine getLightEngine() {
        throw new UnsupportedOperationException();
    }

    public int getBlockTint(BlockPos blockPos, ColorResolver colorResolver) {
        return Objects.requireNonNull(Minecraft.getInstance().level).getBlockTint(blockPos, colorResolver);
    }

    public int getBrightness(LightLayer lightType, BlockPos blockPos) {
        return 15;
    }

    public int getRawBrightness(BlockPos blockPos, int amount) {
        return 15;
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos pos) {
        return null;
    }

    public BlockState getBlockState(BlockPos pos) {
        return this.blocks.getOrDefault(pos, Blocks.AIR.defaultBlockState());
    }

    public FluidState getFluidState(BlockPos pos) {
        return Blocks.AIR.defaultBlockState().getFluidState();
    }

    public int getHeight() {
        return 0;
    }

    public int getMinBuildHeight() {
        return 0;
    }

    public void renderBlocks(PoseStack poseStack) {
        Minecraft mc = Minecraft.getInstance();
        BlockRenderDispatcher dispatcher = mc.getBlockRenderer();
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        RenderSystem.setupGui3DDiffuseLighting((Vector3f)SCENE_LIGHT_1, (Vector3f)SCENE_LIGHT_2);
        this.blocks.forEach((pos, state) -> {
            RenderType renderType = ItemBlockRenderTypes.getRenderType((BlockState)state, (boolean)false);
            VertexConsumer consumer = bufferSource.getBuffer(renderType);
            poseStack.pushPose();
            poseStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            dispatcher.renderBatched(state, pos, (BlockAndTintGetter)this, poseStack, consumer, true, Objects.requireNonNull(mc.level).random);
            poseStack.popPose();
        });
        bufferSource.endBatch();
        Lighting.setupFor3DItems();
    }
}

